
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>PayWise PHP Crypto Test</title>
  <style>
    body { font-family: Arial, sans-serif; max-width: 700px; margin: 40px auto; }
    input[type="text"], textarea { width: 100%; padding: 10px; margin: 10px 0; }
    button { padding: 10px 20px; font-size: 16px; }
    .section { margin-bottom: 30px; padding: 20px; border: 1px solid #ccc; border-radius: 8px; }

    #resultModal {
      display: none;
      position: fixed;
      z-index: 999;
      padding: 40px;
      background: white;
      border: 1px solid #333;
      border-radius: 10px;
      top: 20%;
      left: 50%;
      transform: translate(-50%, -20%);
      box-shadow: 0 0 15px rgba(0,0,0,0.3);
    }

    #resultText {
      white-space: pre-wrap;
      word-wrap: break-word;
      max-width: 500px;
      margin-bottom: 20px;
    }

    #overlay {
      display: none;
      position: fixed;
      top: 0; left: 0;
      width: 100%; height: 100%;
      background: rgba(0,0,0,0.5);
      z-index: 998;
    }
  </style>
</head>
<body>
  <h1>PayWise PHP Crypto Test</h1>

  <div class="section">
    <h2>Encrypt</h2>
    <form id="encryptForm">
      <label>Data to Encrypt:</label>
      <input type="text" name="decryptData" required>

      <label>Encryption Key:</label>
      <input type="text" name="key" required>

      <button type="submit">Encrypt</button>
    </form>
  </div>

  <div class="section">
    <h2>Decrypt</h2>
    <form id="decryptForm">
      <label>Data to Decrypt (Base64):</label>
      <input type="text" name="encryptData" required>

      <label>Encryption Key:</label>
      <input type="text" name="key" required>

      <button type="submit">Decrypt</button>
    </form>
  </div>

  <div id="overlay"></div>
  <div id="resultModal">
    <div id="resultText"></div>
    <button onclick="copyResult()">Copy to Clipboard</button>
    <button onclick="closeModal()">Close</button>
  </div>

  <script>
    const encryptForm = document.getElementById('encryptForm');
    const decryptForm = document.getElementById('decryptForm');
    const resultModal = document.getElementById('resultModal');
    const overlay = document.getElementById('overlay');
    const resultText = document.getElementById('resultText');

    function showModal(content) {
      resultText.textContent = content;
      resultModal.style.display = 'block';
      overlay.style.display = 'block';
    }

    function closeModal() {
      resultModal.style.display = 'none';
      overlay.style.display = 'none';
    }

    function copyResult() {
      navigator.clipboard.writeText(resultText.textContent)
        .then(() => alert("Copied to clipboard!"))
        .catch(err => alert("Failed to copy: " + err));
    }

    encryptForm.addEventListener('submit', async (e) => {
      e.preventDefault();
      const formData = new FormData(encryptForm);
      const params = new URLSearchParams(formData).toString();
      const response = await fetch('pwencryption.php?' + params);
      const text = await response.text();
      showModal(text);
    });

    decryptForm.addEventListener('submit', async (e) => {
      e.preventDefault();
      const formData = new FormData(decryptForm);
      const params = new URLSearchParams(formData).toString();
      const response = await fetch('pwdecryption.php?' + params);
      const text = await response.text();
      showModal(text);
    });
  </script>
</body>
</html>
