# PayWise Java AES Encryption Integration

This library allows Java applications to encrypt and decrypt session codes or payloads compatible with PayWise's PHP-based `aes-256-cbc` encryption scheme.

## 🔐 Algorithm Overview

- AES-256-CBC
- PKCS5Padding
- Key and IV derived using OpenSSL-style EVP_BytesToKey (3 MD5 rounds)
- Salted encryption
- Output: base64-encoded JSON containing `ct`, `iv`, and `s`

## 🧪 Example Usage

### Encrypt a session code
```java
String sessionCode = "ABC123DEF456";
String encrypted = CryptoEncryptor.encryptString(sessionCode, "test_shared_key");
System.out.println("Encrypted: " + encrypted);
```

### Decrypt the session code
```java
String decrypted = CryptoDecryptor.decryptString(encrypted, "test_shared_key");
System.out.println("Decrypted: " + decrypted);  // Should print: ABC123DEF456
```

## 📦 Output Format

Encrypted output (Base64 of JSON):
```json
{
  "ct": "Base64-encoded ciphertext",
  "iv": "hex IV",
  "s": "hex salt"
}
```

This entire JSON is base64-encoded to produce the final string.

## 📄 Files

- `CryptoEncryptor.java` – encrypts session strings
- `CryptoDecryptor.java` – decrypts encrypted strings

## ✅ Compatibility

Fully compatible with PayWise’s PHP code using:
```php
openssl_encrypt($data, 'aes-256-cbc', $key, true, $iv);
```

## 📬 Support

For integration help, contact PayWise at [support@paywise.co].