public class TestCrypto {
    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.out.println("Usage: java TestCrypto <text> <key> <encrypt|decrypt>");
            System.exit(1);
        }

        String text = args[0];
        String key = args[1];
        String mode = args[2].toLowerCase();

        if (mode.equals("encrypt")) {
            String encrypted = CryptoEncryptor.encryptString(text, key);
            System.out.println("Encrypted Output:\n" + encrypted);
        } else if (mode.equals("decrypt")) {
            String decrypted = CryptoDecryptor.decryptString(text, key);
            System.out.println("Decrypted Output:\n" + decrypted);
        } else {
            System.out.println("Invalid mode. Use 'encrypt' or 'decrypt'.");
        }
    }
}

