
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import org.json.JSONObject;

public class CryptoDecryptor {

    public static String decryptString(String base64Input, String secretKey) throws Exception {
        String jsonString = new String(Base64.getDecoder().decode(base64Input));
        JSONObject json = new JSONObject(jsonString);

        byte[] salt = hexStringToByteArray(json.getString("s"));
        byte[] iv = hexStringToByteArray(json.getString("iv"));
        byte[] ct = Base64.getDecoder().decode(json.getString("ct"));

        byte[] key = evpBytesToKey(secretKey.getBytes("UTF-8"), salt);

        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(Cipher.DECRYPT_MODE, keySpec, ivSpec);
        byte[] decrypted = cipher.doFinal(ct);

        String result = new String(decrypted, "UTF-8");

        // Strip quotes if the decrypted string is a JSON string literal
        if (result.startsWith("\"") && result.endsWith("\"")) {
           result = result.substring(1, result.length() - 1);
        }
        return result;
    }

    private static byte[] evpBytesToKey(byte[] pass, byte[] salt) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] dx = new byte[0];
        byte[] result = new byte[0];
        while (result.length < 48) {
            byte[] update = new byte[dx.length + pass.length + salt.length];
            System.arraycopy(dx, 0, update, 0, dx.length);
            System.arraycopy(pass, 0, update, dx.length, pass.length);
            System.arraycopy(salt, 0, update, dx.length + pass.length, salt.length);
            dx = md.digest(update);
            byte[] newResult = new byte[result.length + dx.length];
            System.arraycopy(result, 0, newResult, 0, result.length);
            System.arraycopy(dx, 0, newResult, result.length, dx.length);
            result = newResult;
        }
        return Arrays.copyOfRange(result, 0, 32);
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] output = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            output[i / 2] = (byte) ((Character.digit(s.charAt(i), 16) << 4)
                                 + Character.digit(s.charAt(i+1), 16));
        }
        return output;
    }
}
