
# PayWise Java Crypto Test

This Java-based Docker project allows 3rd-party developers to test AES-256-CBC encryption and decryption compatible with the PayWise PHP system. It ensures full interoperability with the PHP encryption format, including OpenSSL-style key derivation and payload formatting.

---

## 📁 Folder Structure

```
PayWiseCryptoDocker/
├── Dockerfile
├── lib/
│   └── json-20250107.jar         # JSON library for encoding/decoding
└── src/
    ├── CryptoEncryptor.java      # Java AES encryptor compatible with PHP
    ├── CryptoDecryptor.java      # Java AES decryptor compatible with PHP
    └── TestCrypto.java           # CLI runner to call encrypt/decrypt methods
```

---

## 🐳 Docker Setup

### ✅ Step 1: Navigate to the project directory

```bash
cd /path/to/PayWiseJAVADocker
```

---

### 🛠️ Step 2: Build the Docker image

```bash
docker build -t paywise-java-crypto .
```

---

### ▶️ Step 3: Run encryption or decryption

```bash
docker run --rm paywise-java-crypto "<DATA>" "<KEY>" <encrypt|decrypt>
```

#### Arguments:
- `<DATA>`: The session token or encrypted payload
- `<KEY>`: The shared encryption key
- `<encrypt|decrypt>`: Specify the action

#### Example (Encrypt):
```bash
docker run --rm paywise-java-crypto "ABC123" "MySecretKey" encrypt
```

#### Example (Decrypt):
```bash
docker run --rm paywise-java-crypto "<Base64EncryptedPayload>" "MySecretKey" decrypt
```

---

## 🔐 Format Notes

- **Encryption output** is base64-encoded JSON with keys:
  - `ct`: Ciphertext (Base64)
  - `iv`: Initialization Vector (Hex)
  - `s`: Salt (Hex)

- **The plaintext is JSON-quoted** to simulate PHP's `json_encode($value)` behavior

- **The key derivation** uses OpenSSL-compatible EVP_BytesToKey (MD5-based) with salt

---

## 🧪 PHP Compatibility

This project is fully interoperable with the provided PHP endpoints:
- `pwencryption.php`
- `pwdecryption.php`

Scenarios:
| Encrypt in | Decrypt in | Works? |
|------------|------------|--------|
| PHP        | PHP        | ✅     |
| Java       | Java       | ✅     |
| Java       | PHP        | ✅     |
| PHP        | Java       | ✅     |

---

## 🧹 Clean Up

To stop/remove the Docker image if needed:

```bash
docker rmi paywise-java-crypto
```

To remove all dangling builder cache:

```bash
docker builder prune --force
```

---

## 💬 Support

Please contact the PayWise Integration team for sample keys or troubleshooting support.
