# PayWise .NET Crypto Sample

This sample mirrors the behavior of:
- `payWiseEncrypt(secretKey, value)`
- `payWiseDecrypt(secretKey, encryptedBase64)`

It is compatible with the TypeScript implementation in:
- `paywise-dap/src/shared/crypto/encryption.service.ts`

## Algorithm details

- AES-256-CBC
- PKCS7 padding
- 8-byte random salt
- OpenSSL-style `EVP_BytesToKey` key derivation using MD5 chaining
- Envelope format before outer base64:

```json
{
  "ct": "<base64 ciphertext>",
  "iv": "<hex iv>",
  "s": "<hex salt>"
}
```

Final output is `base64(utf8(json-envelope))`.

## Usage

1. Set `secretKey` in `Program.cs`.
2. Run:

```bash
dotnet run
```

## Integrating in your app

- Encrypt token/transaction id:
  - `var encrypted = PayWiseCrypto.EncryptPayWise(secretKey, yourValue);`
- Decrypt response payload:
  - `var plain = PayWiseCrypto.DecryptPayWise<string>(secretKey, encrypted);`

For object payloads, use a DTO type with `DecryptPayWise<YourDto>(...)`.
